package global;

import org.apache.beehive.netui.pageflow.DoubleSubmitException;
import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.GlobalApp;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;

/**
 * The Global page flow is used to define actions which can be invoked by any other
 * page flow in a webapp. The "jpf:catch" annotation provides a global way to catch
 * unhandled exceptions by forwarding to an error page.
 *
 * @jpf:catch type="org.tigris.atlas.web.wlw.InvalidTokenException" method="handleTokenException"
 * @jpf:catch type="Exception" method="handleException"
 */
@Jpf.Controller(catches = { 
    @Jpf.Catch(type = DoubleSubmitException.class,
               method = "handleTokenException"), 
    @Jpf.Catch(type = Exception.class,
               method = "handleException")
})
public class Global extends GlobalApp
{
 
    private static final Log LOG = LogFactory.getLog(GlobalApp.class);
 
    /**
     * @jpf:exception-handler
     * @jpf:forward name="invalidToken" path="/resources/jsp/illegalNavigation.jsp"
     */
    @Jpf.ExceptionHandler(forwards = { 
        @Jpf.Forward(name = "invalidToken",
                     path = "/resources/jsp/illegalNavigation.jsp")
    })
    protected Forward handleTokenException(DoubleSubmitException ex, String actionName, String message, ActionForm form)
    {

        return new Forward("invalidToken");
    }
    
    
    /**
     * @jpf:exception-handler
     * @jpf:forward name="unhandledException" path="/resources/jsp/exception.jsp"
     */
    @Jpf.ExceptionHandler(forwards = { 
        @Jpf.Forward(name = "unhandledException",
                     path = "/resources/jsp/exception.jsp")
		}
	)
    protected Forward handleException( Exception ex, String actionName,
                                       String message, ActionForm form ) {

        LOG.error("Handling an exception", ex);
        return new Forward("unhandledException");
    }
}
